Attribute VB_Name = "Module1"
'
' Module1.bas
'
'  Written by
'  Forrest Mook <forrest@almighty.c64.org>
'  Copyright 1999-2007
'
' Constants and Types for multiple disk formats by
'  Robert Willie <hydradix@yahoo.com>
'  Copyright 2007
'
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or
' (at your option) any later version.
'
' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.
'
' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
' 02111-1307  USA.

'names like blah_71 pertain to 1571 disks
'names like blah_81 pertain to 1581 disks
'names like blah_64 pertain to 1541 disks
'if that last one is confusing, so is the extension .d64
'I didn't start the fire.  It was always burning...

'some constants with c prefix; a numeric count with cn prefix
'some are Int instead of Byte because BASIC will overflow
'and this can't be prevented with CInt() because
'functions are not allowed in Const expressions...
Public Const cBlockSize As Integer = 254
Public Const cSectorSize As Integer = 256
Public Const cnDirentsPerSector As Integer = 8

'for GCR drives: 1540, 1541, 1551, 1570, 1571
Public Const cTrackZone1 As Byte = 1 'first track# in zone
Public Const cnSectorsZone1 As Integer = 21 '#sectors/track in zone
Public Const cTrackZone2 As Byte = 18
Public Const cnSectorsZone2 As Integer = 19
Public Const cTrackZone3 As Byte = 25
Public Const cnSectorsZone3 As Integer = 18
Public Const cTrackZone4 As Byte = 31
Public Const cnSectorsZone4 As Integer = 17
Public Const cTrackZone5 As Byte = 36 'not supported by Sys (CBM DOS)
Public Const cnSectorsZone5 As Integer = 17

'for single-sided GCR drives: 1540, 1541, 1551, 1570
Public Const cnSides64 As Byte = 1
Public Const cnPhySides64 As Byte = 1
Public Const cnTracks64 As Byte = 35 '#tracks supported by Sys (CBM DOS)
Public Const cnPhyTracks64 As Byte = 40
Public Const cPhySectorSize64 As Integer = 256
Public Const cSysTrack64 As Byte = 18 'track of BAM and Dir
Public Const cnSysSectors64 As Byte = cnSectorsZone2  '19
Public Const cnBamSectors64 As Byte = 1
Public Const cnDirSectors64 As Byte = cnSysSectors64 - cnBamSectors64 '18
Public Const cnDirents64 As Integer = cnDirentsPerSector * cnDirSectors64 '144
Public Const cnSectors64 As Integer = (cTrackZone2 - cTrackZone1) * cnSectorsZone1 _
                                    + (cTrackZone3 - cTrackZone2) * cnSectorsZone2 _
                                    + (cTrackZone4 - cTrackZone3) * cnSectorsZone3 _
                                    + (cTrackZone5 - cTrackZone4) * cnSectorsZone4 '683
Public Const cnPhySectors64 As Integer = cnSectors64 + (cnPhyTracks64 + 1 - cTrackZone5) * cnSectorsZone5
Public Const cnBlocks64 As Integer = cnSectors64 - cnSysSectors64 '664

'for dounle-sided GCR drive: 1571
Public Const cnSides71 As Byte = 2
Public Const cnPhySides71 As Byte = 2
Public Const cnTracks71 As Byte = cnSides71 * cnTracks64 '70
Public Const cnPhyTracks71 As Byte = cnPhySides71 * cnPhyTracks64 '80
Public Const cPhySectorSize71 As Integer = 256
Public Const cSysTrack71 As Byte = 18 'track of BAM and Dir
Public Const cnSysSectors71 = cnSides71 * cnSectorsZone2 '38
Public Const cnBamSectors71 As Byte = 1 'on SysTrack; another on track 53
Public Const cnDirSectors71 As Byte = cnSectorsZone2 - cnBamSectors71 '18
Public Const cnDirents71 As Integer = cnDirentsPerSector * cnDirSectors71  '144
Public Const cnSectors71 As Integer = cnSides71 * cnSectors64 '1366
Public Const cnPhySectors71 As Integer = cnPhySides71 * cnPhySectors64
Public Const cnBlocks71 As Integer = cnSectors71 - cnSysSectors71 '1328

'for dounle-sided MFM drive: 1581
Public Const cnSectorsTrack81 As Integer = 40 'Sys (CBM DOS) #sectors/track
Public Const cnPhySectorsTrack81 As Integer = 10 'physical #sectors/track

Public Const cnSides81 As Byte = 1 'Sys (CBM DOS) #sides/disk
Public Const cnPhySides81 As Byte = 2 'Physical #sides/disk
Public Const cnTracks81 As Byte = 80 * cnSides81 '80 tracks/disk
Public Const cnPhyTracks81 As Byte = 80 * cnPhySides81 '160 tracks/disk
Public Const cPhySectorSize81 As Integer = 512
Public Const cSysTrack81 As Byte = 40 'track of BAM and Dir
Public Const cnSysSectors81 = cnSides81 * cnSectorsTrack81 '40
Public Const cnBamSectors81 As Byte = 3 'actually 2 plus 1 for header
Public Const cnDirSectors81 As Byte = cnSysSectors81 - cnBamSectors81 '37
Public Const cnDirents81 As Integer = cnDirentsPerSector * cnDirSectors81  '296
Public Const cnSectors81 As Integer = cnSides81 * cnTracks81 * cnSectorsTrack81 '3200
Public Const cnPhySectors81 As Integer = cnPhyTracks81 * cnPhySectorsTrack81 * cnPhySides81 '1600
Public Const cnBlocks81 As Integer = cnSectors81 - cnSysSectors81 '3160

Public Const cnMaxSectors As Integer = cnSectors81
Public Const cnMaxDirents As Integer = cnDirents81

Public Type blockLink
    track As Byte
    sector As Byte
End Type

'vars for disk image
'some disks have extra dir entries not on the dir track
'CBM DOS can list and open such files (otherwise not supported)
'these non-standard entries are the reason for maxDirents and maxDirents2
'maxDirents includes non-standard entries if any
'maxDirents2 only considers standard entries
Public Type imageInfo
    imageType As String 'D64 D71 or D81
    hasErrors As Boolean
    sides As Byte
    maxTracks As Byte 'max allowed in image type
    tracks As Byte 'actual # in image
    sysTrack As Byte 'd64,d71 = 18; d81=40
    sysSectors As Byte
    bamSectors As Byte
    bamSize As Byte '#bytes in track bitmap
    bamStart As Byte 'offset in sector to start of BAM
    nameStart As Byte 'offset in sector to disk name & ID
    dirSectors As Byte 'nSysSectors - nBamSectors
    maxDirents2 As Integer 'nDirSectors * 8
    dirents As Integer 'actual#
    sectors As Integer 'actual total, like nTracks * Sectors/Track
    blocks As Integer 'nSectors - nSysSectors; for files
    allocated As Integer 'blocks used by files
    dirUsed As Byte 'blocks used by directory
    dirFree As Byte 'usually nDirSectors - nDirAllocated
    maxDirents As Integer ' (nDirAllocated + nDirFree) * 8
    dirInterleave As Byte
    zoneInterleave(1 To 5) As Byte
    geoBorder As blockLink
End Type

'current disk image
Public dimage As imageInfo

Public Type cbmDirent
    filetype As Byte
    start As blockLink 'data first track & sector
    name As String 'max 16 chars, in directory right padded with &hA0
    info As blockLink 'REL side-sector / GEOS info track & sector
    relLength As Byte 'also GEOS file structure (0=seq, 1=vlir)
    geoType As Byte '0 = standard CBM file
    geoYear As Byte 'warning: year 2156 bug
    geoMonth As Byte
    geoDate As Byte
    geoHour As Byte 'also temp track during @save
    geoMinute As Byte 'also temp sector during @save
    size As Integer 'in blocks (254 bytes)
    'extra info not stored in directory
    dataBytes As Long 'for PRG,USR,SEQ and data of REL,VLIR
    indexBytes As Integer 'for REL side-sectors and VLIR table
    infoBytes As Integer 'for GEOS info block
    vlirBlocks As Integer 'needed cuz blocks <> dataBytes \ 254
End Type

Public GeoTypeName(0 To 31) As String 'elements defined in frmMain:Form_Load
Public GeoTypeCount As Byte

Public sDirents(0 To cnMaxDirents + 1) As cbmDirent

Public FTYPE As String
Public strBin As String
Public FILECLOSED As String
Public FILELOCKED As String

Public varForBlockViewer As Integer
Public firstKeyPressValue As Integer
Public firstKeyPressToggle As Integer

Public Type cbmBlock
    bambite As Integer
    allocated As Integer 'normally 0 or 1, more if cross-linked
    wipe As Boolean 'needs wiping
    viewed As Integer 'detect loops, mark order
    errorCode As Byte '0 = ok
    parent As Integer  'previous block in file chain, if any
    owner As String 'filename, if any
End Type

Public sBlocks(0 To cnMaxSectors) As cbmBlock

Public ImportFilenames(0 To 100) As String

Public D64Modified As Boolean
Public cantFitDirOnDisk As Integer

Public operatingSystemVersion As Integer
Public WindowsDirectoryPath As String
Public seperatorLineText As String
Public FileNotWiped As Integer
Public convertToASCII As Integer
Public HexEnabled As Boolean:  ' So HexEditor doesnt go into infinite loop

Public ltemp As Long
Public convertedSector As Integer
Public convertedTrack As Integer

'variables needed for saving window states
Public frmBAMLEFT As Integer
Public frmBAMTOP As Integer
Public frmBlockViewerLEFT As Integer
Public frmBlockViewerTOP As Integer
Public frmFilePropertiesLEFT As Integer
Public frmFilePropertiesTOP As Integer
Public frmMainLEFT As Integer
Public frmMainTOP As Integer
Public frmSectorDumpLEFT As Integer
Public frmSectorDumpTOP As Integer
Public frmCrossLinksLEFT As Integer
Public frmCrossLinksTOP As Integer
Public frmFileViewerTOP As Integer
Public frmFileViewerLEFT As Integer
Public frmConfigLEFT As Integer
Public frmConfigTOP As Integer
Public frmMemoryLEFT As Integer
Public frmMemoryTOP As Integer
Public frmFileNameBuilderLEFT As Integer
Public frmFileNameBuilderTOP As Integer
Public frmMainCreateNewD64LEFT As Integer
Public frmMainCreateNewD64TOP As Integer
Public lastDirPath As String
Public FileExportPath As String
Public DirEntryBeingEdited As Integer
Public warningsDisabled As Integer
Public safeClean As Integer
Public disableCrosslinkCheck As Integer
Public FileViewerColumnMode As Integer
Public OriginalFileName As String
Public TempFileName1 As String
Public BlockViewerASCIIMode As Integer
Public FileNameBuilderSTR As String
Public FirstBlockToUse As Integer
Public CurrentBlockBeingWritten As Integer
Public nextBlocktoUse As Integer
Public block As Integer
Public track As Integer
Public sector As Integer
Public distance As Integer
Public direction As Integer ' 1 = upward , 2 = downward
Public SelectNextFileUponSaveVar As Integer
Public treatTrack18FilesAsEmpty As Integer


' Memory Cache variables
Public memoryCache(0 To 200) As String
Public memoryFilename(0 To 200) As String
Public memoryFileType(0 To 200) As Byte
Public memoryFileLength(0 To 200) As Long
Public memorydisplayFilename(0 To 200) As String




Public Declare Function GetTempFilename Lib "kernel32" Alias _
   "GetTempFileNameA" (ByVal lpszPath As String, ByVal lpPrefixString _
   As String, ByVal wUnique As Long, ByVal lpTempFileName As String) As Long

   Public Declare Function GetTempPath Lib "kernel32" Alias _
   "GetTempPathA" (ByVal nBufferLength As Long, ByVal lpBuffer _
   As String) As Long



  ' All of this crap before form_load and most of list1_mousedown used for highlighting
  ' the file when right clicking on it.
  ' Taken from the following web address.
  ' http://www.mvps.org/vbnet/code/listapi/rightmouseclick.htm
  Public Const LB_ITEMFROMPOINT As Long = &H1A9

  Public Declare Function SendMessage Lib "user32" _
     Alias "SendMessageA" _
   (ByVal hWnd As Long, _
     ByVal wMsg As Long, _
     ByVal wParam As Long, _
     lParam As Long) As Long
     
  Public Declare Sub CopyMemory Lib "kernel32" _
     Alias "RtlMoveMemory" _
    (Destination As Any, Source As Any, _
     ByVal Length As Long)


  Public Declare Function GetCursorPos Lib "user32" _
    (lpPoint As POINTAPI) As Long

  Public Declare Function ScreenToClient Lib "user32" _
    (ByVal hWnd As Long, lpPoint As POINTAPI) As Long


Public Type BROWSEINFO
    hOwner As Long
    pidlRoot As Long
    pszDisplayName As String
    lpszTitle As String
    ulFlags As Long
    lpfn As Long
    lParam As Long
    iImage As Long
  End Type

  Public Declare Function SHBrowseForFolder Lib _
     "shell32.dll" Alias "SHBrowseForFolderA" _
     (lpBrowseInfo As BROWSEINFO) As Long

  Public Declare Function SHGetPathFromIDList Lib _
     "shell32.dll" Alias "SHGetPathFromIDListA" _
     (ByVal pidl As Long, _
     ByVal pszPath As String) As Long

  Public Declare Sub CoTaskMemFree Lib "ole32.dll" (ByVal pv As Long)


      
  Public Const MAX_PATH = 260
  Public Const WM_USER = &H400
  Public Const BFFM_INITIALIZED = 1

  'Constants ending in 'A' are for Win95 ANSI
  'calls; those ending in 'W' are the wide Unicode
  'calls for NT.

  'Sets the status text to the null-terminated
  'string specified by the lParam parameter.
  'wParam is ignored and should be set to 0.
  Public Const BFFM_SETSTATUSTEXTA As Long = (WM_USER + 100)
  Public Const BFFM_SETSTATUSTEXTW As Long = (WM_USER + 104)

  'If the lParam  parameter is non-zero, enables the
  'OK button, or disables it if lParam is zero.
  '(docs erroneously said wParam!)
  'wParam is ignored and should be set to 0.
  Public Const BFFM_ENABLEOK As Long = (WM_USER + 101)

  'Selects the specified folder. If the wParam
  'parameter is FALSE, the lParam parameter is the
  'PIDL of the folder to select , or it is the path
  'of the folder if wParam is the C value TRUE (or 1).
  'Note that after this message is sent, the browse
  'dialog receives a subsequent BFFM_SELECTIONCHANGED
  'message.
  Public Const BFFM_SETSELECTIONA As Long = (WM_USER + 102)
  Public Const BFFM_SETSELECTIONW As Long = (WM_USER + 103)


Public Declare Function GetWindowsDirectory Lib "kernel32" Alias "GetWindowsDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long

' code to get the Windows version taken from http://vbapi.com/ref/g/getversionex.html
Public Declare Function GetVersionEx Lib "kernel32.dll" Alias "GetVersionExA" (lpVersionInformation As OSVERSIONINFO) As Long

Type OSVERSIONINFO
  dwOSVersionInfoSize As Long
  dwMajorVersion As Long
  dwMinorVersion As Long
  dwBuildNumber As Long
  dwPlatformId As Long
  szCSDVersion As String * 128
End Type


'specific to the PIDL method
  'Undocumented call for the example. IShellFolder's
  'ParseDisplayName member function should be used instead.
  Public Declare Function SHSimpleIDListFromPath Lib _
     "shell32" Alias "#162" _
     (ByVal szPath As String) As Long
     
     
 Public Function BrowseCallbackProc(ByVal hWnd As Long, _
                                     ByVal uMsg As Long, _
                                     ByVal lParam As Long, _
                                     ByVal lpData As Long) As Long
    'Callback for the Browse PIDL method.
    'On initialization, set the dialog's
    'pre-selected folder using the pidl
    'set as the bi.lParam, and passed back
    'to the callback as lpData param.
   
     Select Case uMsg
        Case BFFM_INITIALIZED
        
           Call SendMessage(hWnd, BFFM_SETSELECTIONA, _
                            False, ByVal lpData)
                            
           Case Else:
           
     End Select

  End Function


  Public Function FARPROC(pfn As Long) As Long
    
    'A dummy procedure that receives and returns
    'the value of the AddressOf operator.
   
    'Obtain and set the address of the callback
    'This workaround is needed as you can't assign
    'AddressOf directly to a member of a user-
    'defined type, but you can assign it to another
    'long and use that (as returned here)
   
    FARPROC = pfn

  End Function
   

Sub getOSVersion()
  Dim os As OSVERSIONINFO  ' receives version information
  Dim retval As Long  ' return value

  os.dwOSVersionInfoSize = Len(os)  ' set the size of the structure
  retval = GetVersionEx(os)

    'detect if running Win95/98
  If os.dwPlatformId = 1 Then
     frmMain.OLEDropMode = 1
     operatingSystemVersion = 1
  End If

    'detect if running WinNT/2000
  If os.dwPlatformId = 2 Then
     frmMain.OLEDropMode = 0
     operatingSystemVersion = 2
  End If

End Sub

    
Public Function LoWord(dwValue As Long) As Integer

    CopyMemory LoWord, dwValue, 2
    
  End Function


  Public Function MAKELONG(wLow As Long, wHigh As Long) As Long

    MAKELONG = LoWord(wLow) Or (&H10000 * LoWord(wHigh))
    
  End Function


  Public Function MAKELPARAM(wLow As Long, wHigh As Long) As Long

   'Combines two integers into a long integer
    MAKELPARAM = MAKELONG(wLow, wHigh)
    
  End Function

Public Function BrowseForFolderByPIDL(sSelPath As String) As String

     Dim BI As BROWSEINFO
     Dim pidl As Long
     Dim spath As String * MAX_PATH
    
     With BI
        .hOwner = frmMain.hWnd
        .pidlRoot = 0
        .lpszTitle = "Select a folder to Export Files into."
        .lpfn = FARPROC(AddressOf BrowseCallbackProc)
        .lParam = GetPIDLFromPath(sSelPath)
     End With
    
     pidl = SHBrowseForFolder(BI)
    
     If pidl Then
        If SHGetPathFromIDList(pidl, spath) Then
           BrowseForFolderByPIDL = Left$(spath, InStr(spath, vbNullChar) - 1)
        End If
       
       'free the pidl returned by call to SHBrowseForFolder
        Call CoTaskMemFree(pidl)
    End If
    
   'free the pidl set in call to GetPIDLFromPath
    Call CoTaskMemFree(BI.lParam)
    
  End Function


  Public Function GetPIDLFromPath(spath As String) As Long

    'return the pidl to the path supplied by calling the
    'undocumented API #162 (our name SHSimpleIDListFromPath).
    'This function is necessary as, unlike documented APIs,
    'the API is not implemented in 'A' or 'W' versions.

      ' If OS is NT then do this, otherwise it's win95
    If operatingSystemVersion = 2 Then
      GetPIDLFromPath = SHSimpleIDListFromPath(StrConv(spath, vbUnicode))
    Else
      GetPIDLFromPath = SHSimpleIDListFromPath(spath)
    End If

  End Function


Public Function UnqualifyPath(spath As String) As String

    'qualifying a path usually involves assuring
    'that its format is valid, including a trailing slash
    'ready for a filename. Since the SHBrowseForFolder API
    'will pre-select the path if it contains the trailing
    'slash, I call stripping it 'unqualifying the path'.
     If Len(spath) > 0 Then
     
        If Right$(spath, 1) = "\" Then
        
           UnqualifyPath = Left$(spath, Len(spath) - 1)
           Exit Function
        
        End If
     
     End If
     
     UnqualifyPath = spath
     
  End Function

Public Function chopFilename(ByVal padName As String) As String
Dim u As Integer
Dim hitanA0 As Integer
Dim firstTime As Boolean
Dim tempVar As Boolean
    If Len(padName) < 16 Then
        Stop
    End If
     For u = 1 To 16
        If Mid(padName, u, 1) = "" Then
             If firstTime = 0 Then
               hitanA0 = u
               firstTime = 1
             End If
             tempVar = 1
        End If
        
        If tempVar = 0 Then
          
          If firstTime = 1 Then
             hitanA0 = 0
             firstTime = 0
          End If
        End If
        
        tempVar = 0
     Next u
        ' if $A0 ends up being 0 then the whole filename is used
        If hitanA0 = 0 Then
          hitanA0 = 17
        End If

        chopFilename = Left(padName, hitanA0 - 1)
End Function

Sub GetWinDir()
  Dim buf As String * 256
  Dim return_len As Long
  return_len = GetWindowsDirectory(buf, Len(buf))
  WindowsDirectoryPath = Left$(buf, return_len)
  frmMain.Label4.Caption = Left$(buf, return_len) & "\d64editor.cfg"
End Sub
               
               
               
            
               
               
               
Sub saveWindowLocations()
  Call GetWinDir
'  cfgFilePath = windir & "\d64editor.cfg"

  If Right(FileExportPath, 1) = "\" Then
     FileExportPath = Left(FileExportPath, Len(FileExportPath) - 1)
  End If
  Open frmMain.Label4.Caption For Output As #1
      Print #1, lastDirPath
      Print #1, frmBAMTOP, "frmBAMTOP"
      Print #1, frmBAMLEFT, "frmBAMLEFT"
      Print #1, frmBlockViewerTOP, "frmBlockViewerTOP"
      Print #1, frmBlockViewerLEFT, "frmBlockViewerLEFT"
      Print #1, frmFilePropertiesTOP, "frmFilePropertiesTOP"
      Print #1, frmFilePropertiesLEFT, "frmFilePropertiesLEFT"
      Print #1, frmMainTOP, "frmMainTOP"
      Print #1, frmMainLEFT, "frmMainLEFT"
      Print #1, frmSectorDumpTOP, "frmSectorDumpTOP"
      Print #1, frmSectorDumpLEFT, "frmSectorDumpLEFT"
      Print #1, frmCrossLinksTOP, "frmCrossLinksTOP"
      Print #1, frmCrossLinksLEFT, "frmCrossLinksLEFT"
      Print #1, frmFileViewerTOP, "frmFileViewerTOP"
      Print #1, frmFileViewerLEFT, "frmFileViewerLEFT"
      Print #1, FileExportPath
      Print #1, warningsDisabled, "warningsDisabled"
      Print #1, safeClean, "safeClean"
      Print #1, disableCrosslinkCheck, "disableCrosslinkCheck"
      Print #1, frmConfigTOP, "frmConfigTOP"
      Print #1, frmConfigLEFT, "frmConfigLEFT"
      Print #1, frmMemoryTOP, "frmMemoryTOP"
      Print #1, frmMemoryLEFT, "frmMemoryLEFT"
      Print #1, FileViewerColumnMode, "FileViewerColumnMode"
      Print #1, convertToASCII, "ConvertToASCII"
      Print #1, seperatorLineText
      Print #1, BlockViewerASCIIMode, "BlockViewerASCIIMode"
      Print #1, frmFileNameBuilderTOP, "frmFileNameBuilderTOP"
      Print #1, frmFileNameBuilderLEFT, "frmFileNameBuilderLEFT"
      Print #1, frmMainCreateNewD64TOP, "frmMainCreateNewD64TOP"
      Print #1, frmMainCreateNewD64LEFT, "frmMainCreateNewD64LEFT"
      Print #1, SelectNextFileUponSaveVar, "SelectNextFileUponSaveVar"
      Print #1, treatTrack18FilesAsEmpty, "TreatTrack18FilesAsEmpty"
  Close #1
End Sub


Sub GETFILETYPE(strBin As String)
   FILECLOSED = ""
   FILELOCKED = ""
   FTYPE = "???"
   
   If Left(strBin, 1) = "0" Then
      FILECLOSED = "*"
   End If
   
   If Mid(strBin, 2, 1) = "1" Then
      FILELOCKED = "<"
   End If
      
   If Right(strBin, 3) = "100" Then
      FTYPE = "REL"
   End If
      
   If Right(strBin, 3) = "011" Then
      FTYPE = "USR"
   End If
   
   If Right(strBin, 3) = "010" Then
      FTYPE = "PRG"
   End If
   
   If Right(strBin, 3) = "001" Then
      FTYPE = "SEQ"
   End If
   
   If Right(strBin, 3) = "000" Then
      FTYPE = "DEL"
    End If
    
   
End Sub


Sub unAllocateDirSectors()
Dim z As Long
Dim nextDirSector As Byte
Dim nextDirTrack As Byte
Dim curDirTrack As Integer
Dim curDirSector As Integer


Open frmMain.dialogopen.Filename For Binary As #1
curDirTrack = 18
curDirSector = 1

z = 91649

' unallocate 18/1
sBlocks(358).allocated = 0


For t = 1 To 18
Y = 0

Get #1, z, nextDirTrack
Get #1, z + 1, nextDirSector

 ' check to see if this is the last directory sector
   If nextDirSector = "0" Or nextDirTrack = "0" Then
     Close #1
     Exit Sub
   End If
   
   If nextDirTrack = &H12 Then
      sBlocks(nextDirSector + 357).allocated = 0
   Else
      MsgBox "The Directory is not located completely on track 18!" & vbCrLf & "Do not edit this D64 with this program!", vbCritical
   End If

z = z + (256 * (nextDirSector - curDirSector))
curDirSector = nextDirSector

Next t
Close #1
'  ---- END UNALLOCATING DIRECTORY SECTORS


End Sub

Sub checkForFullDir()
    cantFitDirOnDisk = 0
    If dimage.dirents >= dimage.maxDirents Then
        cantFitDirOnDisk = 1
'        If vbYes = MsgBox("Directory full.  Create non-standard directory to make file fit?", vbQuestion Or vbYesNo, "Directory Full") Then
    End If
End Sub

Sub checkForFullDirOld()

Dim z As Long
Dim nextDirSector As Byte
Dim nextDirTrack As Byte
Dim curDirTrack As Integer
Dim curDirSector As Integer
Dim dirBlocks(0 To 18) As Integer
Dim countString As String
Dim countVar As Double

For i = 0 To 18
    dirBlocks(i) = sBlocks(i + 357).allocated
Next i

cantFitDirOnDisk = 0
Open frmMain.dialogopen.Filename For Binary As #1
curDirTrack = 18
curDirSector = 1

z = 91649

dirBlocks(1) = 0



For t = 1 To 18
Y = 0

Get #1, z, nextDirTrack
Get #1, z + 1, nextDirSector

 ' check to see if this is the last directory sector
   If nextDirSector = "0" Or nextDirTrack = "0" Then
     Close #1
           
        ' don't check 18/0, it should never be used for a dir sector
       For i = 1 To 18
         If dirBlocks(i) = 0 Then
            blockfree = blockfree + 1
         End If
       Next i
    
       ' now that we know how many total DIR sectors we can use,
       ' lets see if the new directory will fit into that.
         countVar = (frmMain.List1.ListCount + 1) / 8
         countString = countVar
         
         If countVar < 10 Then
           If Len(countString) > 1 Then  'not a whole number, lets chop off and round up
              countVar = Val(Left(countString, 1)) + 1
              ' now we should know how much DIR sector's we'll need to write out the DIR
            End If
         End If
         
         If countVar > 9 Then
           If Len(countString) > 2 Then
              countVar = Val(Left(countString, 2)) + 1
           End If
           
         End If
         
         
        If countVar > blockfree Then  ' uh oh, directory is too big to fit on the disk
            cantFitDirOnDisk = 1
            Exit Sub
        End If
        

     Exit Sub
   End If
   
   If nextDirTrack = &H12 Then
      dirBlocks(nextDirSector) = 0
'      blocksAllocated(nextDirSector + 357) = 0
   Else
      MsgBox "The Directory is not located completely on track 18!" & vbCrLf & "Do not edit this D64 with this program!", vbCritical
   End If

z = z + (256 * (nextDirSector - curDirSector))
curDirSector = nextDirSector

Next t
Close #1



End Sub

Sub writeOutDirectory()
Dim BITE As Byte
Dim tstring As String
Dim b As Integer
Dim z As Long
Dim Y As Integer
Dim nextDirSector As Byte
Dim nextDirTrack As Byte
Dim curDirTrack As Integer
Dim curDirSector As Integer
Dim displayDiskName As String
Dim firstDirSector As Integer
Dim totalfiles As Integer
Dim pblk As blockLink

    ' first unallocate the existing directory sectors
  Call unAllocateDirSectors
  D64Modified = True
  
curDirTrack = 18
curDirSector = 1

totalfiles = frmMain.List1.ListCount

' track 18/1
firstDirSector = 358

b = 0
Open frmMain.dialogopen.Filename For Binary As #1
z = 91649 'start of track 18/1

' set next dir sector
firstDirSector = firstDirSector + 3

  displayDiskName = frmMain.txtDiskName.Text

  If Len(frmMain.txtDiskName.Text) < 16 Then
     For m = Len(frmMain.txtDiskName.Text) To 15
       displayDiskName = displayDiskName & ""
     Next m
  End If
  
  If Len(frmMain.txtDiskID.Text) < 5 Then
     For m = Len(frmMain.txtDiskID.Text) To 4
       frmMain.txtDiskID.Text = frmMain.txtDiskID.Text & ""
     Next m
  End If


  Put #1, (z + &H90 - 256), displayDiskName
  Put #1, (z + &HA2 - 256), frmMain.txtDiskID.Text

' 18 possible directory sectors used
For t = 1 To 18
Y = 0

' If there are more than 8 files, set the next dir track/sector
If totalfiles > 8 Then
 
   Do Until sBlocks(firstDirSector).allocated = 0
     
     If sBlocks(firstDirSector).allocated = 1 Then
        firstDirSector = firstDirSector + 1
        If firstDirSector > 375 Then
          firstDirSector = 359
        End If
     End If
   Loop
  
  ' After finding a free directory sector, allocate it
  sBlocks(firstDirSector).allocated = 1
  
  pblk = blockNum2TrackandSector(firstDirSector)
  firstDirSector = firstDirSector + 3
Else

  pblk.track = &H0
  pblk.sector = &HFF
End If

      ' fill the block with 0's first
      varString$ = String$(256, 0)
      Put #1, z, varString$

Put #1, z, pblk.track
Put #1, z + 1, pblk.sector

' loop through each directory sector 8 times
For c = 0 To 7
If sDirents(b).name = "" Then
  Close #1
  Exit Sub
End If

Put #1, (z + &H5 + Y), sDirents(b).name
If Len(sDirents(b).name) < 16 Then
    Dim i As Integer
    For i = Len(sDirents(b).name) To 16
        Put #1, (z + &H5 + Y + i - 1), Chr$(&HA0)
    Next
End If

BITE = sDirents(b).start.track
Put #1, z + &H3 + Y, BITE

BITE = sDirents(b).start.sector
Put #1, z + &H4 + Y, BITE

BITE = sDirents(b).size And 255
Put #1, z + &H1E + Y, BITE

BITE = sDirents(b).size \ 256
Put #1, z + &H1F + Y, BITE

BITE = sDirents(b).filetype
Put #1, z + &H2 + Y, BITE

BITE = sDirents(b).info.track
Put #1, z + &H15 + Y, BITE

BITE = sDirents(b).info.sector
Put #1, z + &H16 + Y, BITE

BITE = sDirents(b).relLength
Put #1, z + &H17 + Y, BITE

BITE = sDirents(b).geoType
Put #1, z + &H18 + Y, BITE

BITE = sDirents(b).geoYear
Put #1, z + &H19 + Y, BITE

BITE = sDirents(b).geoMonth
Put #1, z + &H1A + Y, BITE

BITE = sDirents(b).geoDate
Put #1, z + &H1B + Y, BITE

BITE = sDirents(b).geoHour
Put #1, z + &H1C + Y, BITE

BITE = sDirents(b).geoMinute
Put #1, z + &H1D + Y, BITE

totalfiles = totalfiles - 1
Y = Y + &H20
   b = b + 1
Next c



 ' check to see if this is the last directory sector
If pblk.track = 0 Then
   Close #1
   Exit Sub
End If


z = CLng(cSectorSize) * convertTrackSectorToBlock(pblk.track, pblk.sector)
curDirSector = pblk.sector

Next t
Close #1


End Sub

Function getLastSector(track As Byte) As Byte
    If dimage.imageType <> "D81" Then
        If track < cTrackZone2 Or dimage.imageType = "D71" And CInt(track) - CInt(cnTracks64) >= cTrackZone1 And CInt(track) - CInt(cnTracks64) < cTrackZone2 Then
            getLastSector = cnSectorsZone1 - 1
        ElseIf track < cTrackZone3 Or dimage.imageType = "D71" And CInt(track) - CInt(cnTracks64) >= cTrackZone2 And CInt(track) - CInt(cnTracks64) < cTrackZone3 Then
            getLastSector = cnSectorsZone2 - 1
        ElseIf track < cTrackZone4 Or dimage.imageType = "D71" And CInt(track) - CInt(cnTracks64) >= cTrackZone3 And CInt(track) - CInt(cnTracks64) < cTrackZone4 Then
            getLastSector = cnSectorsZone3 - 1
        Else
            getLastSector = cnSectorsZone4 - 1
        End If
    Else
        getLastSector = cnSectorsTrack81 - 1
    End If
End Function

Sub READBAM()
   Dim z As Long
   Dim i As Long
   Dim b As Integer
   Dim t As Byte
   Dim s As Byte
   Dim lastTrack As Byte
   Dim lastSector As Byte
   Dim BCount As Byte
   Dim BMap As Byte
   Dim count As Byte
   Dim countAll As Integer
   Dim trackCombined As String
   Dim didMsgCountTrk As Boolean
   Dim didMsgWrong As Long
   Dim didMsgRandom As Boolean
   '  ------- START BAM READ, READ INTO blocksAllocated Array  --------
   Open frmMain.dialogopen.Filename For Binary As #1
   
    'set up pointer to BAM
   z = convertTrackSectorToBlock(dimage.sysTrack, 0) * CLng(cSectorSize) + 1 'first byte of system track (sector 0)
   If dimage.imageType = "D81" Then
      lastTrack = cnTracks81
      z = z + cSectorSize 'BAM starts on sector 1
   ElseIf dimage.imageType = "D71" Then
      lastTrack = cnTracks71
   Else
      lastTrack = cnTracks64 'never include extended tracks
   End If
   i = z + dimage.bamStart
   b = 0


  For t = 1 To lastTrack
    If t = 41 And dimage.imageType = "D81" Then i = i + dimage.bamStart 'BAM sector 2
    
    If t > cnTracks64 And dimage.imageType = "D71" Then i = z + 220 + t - cnTracks64
    Get #1, i, BCount   ' claimed #free sectors on track
    
    If t > cnTracks64 And dimage.imageType = "D71" Then
        i = z + CLng(cnSectors64) * cSectorSize + (t - cnTracks64 - 1) * dimage.bamSize
    Else
        i = i + 1
    End If
    
    trackCombined = ""
    For s = 1 To dimage.bamSize
        Get #1, i, BMap
        i = i + 1
        Call convDecToBin(BMap)
        trackCombined = strBin & trackCombined
    Next s

    lastSector = getLastSector(t)
    
    count = 0 'calculated #free sectors on track
    For s = 0 To lastSector
        If Right$(trackCombined, 1) = 0 Then
        ' supposedly allocated
            If sBlocks(b).allocated = 0 Then
            'not allocated by file or system
                sBlocks(b).allocated = 1
                If dimage.imageType = "D71" And t = 53 Then
                'silly Commodore allocates all of track 53 but only uses sector 0 (for BAM)
                    sBlocks(b).owner = "** 1571 WASTE **"
                Else
                    If didMsgRandom = False Then didMsgRandom = vbYes = MsgBox("Unreferenced block (" & t & "," & s & ") is allocated in BAM." _
                        & vbCrLf & "This may be a random file." & vbCrLf & "Suppress further warnings?", vbQuestion Or vbYesNo, "BAM Notice")
                    sBlocks(b).owner = "* RANDOM  FILE *"
                End If
                If t = dimage.sysTrack Then
                    dimage.dirFree = dimage.dirFree - 1
                    dimage.maxDirents = dimage.maxDirents - cnDirentsPerSector
                Else 'not Dir track
                    dimage.allocated = dimage.allocated + 1
                End If
            End If
        Else
        ' supposedly free
            count = count + 1
            If sBlocks(b).allocated Then
            'actually in use!
                Dim ask As Boolean
                ask = False
                If didMsgWrong = 0 Then
                    ask = True
                    didMsgWrong = MsgBox("Block (" & t & "," & s & ") used by " & Chr$(34) & chopFilename(sBlocks(b).owner) & Chr$(34) & " is marked free in BAM." & _
                            vbCrLf & "Fix BAM by allocating the block?", vbExclamation Or vbYesNo, "BAM Error")
                End If
                If didMsgWrong = vbYes Then 'fix it
                    count = count - 1
                    BCount = BCount - 1
                    D64Modified = True
                Else 'use wrong value
                    sBlocks(b).allocated = -sBlocks(b).allocated 'remember correct value and mark as free (negative)
                    If t = dimage.sysTrack Then
                        'gotta be carefull w/dir track!
                        If s > dimage.bamSectors And sBlocks(b).owner <> "*DISK DIRECTORY*" Then
                            dimage.dirFree = dimage.dirFree + 1
                            dimage.maxDirents = dimage.maxDirents + cnDirentsPerSector
                        End If
                    ElseIf Not (dimage.imageType = "D71" And t = dimage.sysTrack + cnTracks64 And s = 0) Then
                        'not Dir track and not D71 BAM Side 2
                        dimage.allocated = dimage.allocated - 1 'more free blocks
                    End If
                End If
                If ask Then
                    If vbNo = MsgBox("Treat other such errors the same way?", vbQuestion Or vbYesNo, "BAM Error") Then
                        didMsgWrong = 0 'forget answer, ask again next time
                    End If
                End If
            Else
            'block really is free
                sBlocks(b).owner = "** FREE BLOCK **"
            End If
        End If
contSect:
        trackCombined = Left$(trackCombined, Len(trackCombined) - 1)
        b = b + 1
    Next s
    'check extra bits, if any
    While Len(trackCombined)
        If Right$(trackCombined, 1) Then
            count = count + 1
        End If
        trackCombined = Left$(trackCombined, Len(trackCombined) - 1)
    Wend
      
    If count <> BCount And didMsgCountTrk = False Then
        didMsgCountTrk = vbYes = MsgBox("Free block count of track " & t & " doesn't match bitmap." _
                & vbCrLf & "D64 Editor automatically fixes this type of error." _
                & vbCrLf & "Suppress further such messages?", vbExclamation Or vbYesNo, "BAM Error")
        'we don't offer to fix this because we always write track bitmap to match track free count
        D64Modified = True
    End If
        
    countAll = countAll + count
  Next t
  
    didMsgWrong = False 'assume correct count
    If dimage.imageType = "D64" And dimage.tracks > cnTracks64 Then
        'special for extended d64
        didMsgWrong = 664 - dimage.allocated = countAll
    Else
        didMsgWrong = dimage.sectors - dimage.sysSectors - dimage.allocated = countAll
    End If
    If didMsgWrong Then MsgBox "The BAM claims " & countAll & "blocks are free " _
        & vbCrLf & "but D64 Editor calculated " & dimage.blocks - dimage.allocated & ".", vbInformation Or vbOKCancel, "Blocks Free Error"
    frmMain.lblBlocksFree = dimage.blocks - dimage.allocated & " BLOCKS FREE."
     
   Close #1
   '  ------- END BAM READ  --------

End Sub

Sub BAMWRITE()
   Dim z As Long
   Dim i As Long
   Dim o As Integer
   Dim r As Integer
   Dim BBITE1 As Byte
   Dim BBITE2 As Byte
   Dim BBITE3 As Byte
   Dim BBITE4 As Byte
   Dim trackPart1 As String
   Dim trackPart2 As String
   Dim trackPart3 As String
   Dim trackCombined As String
   Dim bamSectors As String


   Dim t As Integer
   Dim b As Integer
   Dim blocksFreeCounter As Integer
   Dim tpart1ToBite As Byte
   Dim tpart2ToBite As Byte
   Dim tpart3ToBite As Byte
   Dim blocks2Bite As Byte
   Dim totalBlocksFreeCounter As Integer
   
   ' -------- START BAM SAVE   -------
    
    D64Modified = True
    
    Open frmMain.dialogopen.Filename For Binary As #1
    
  i = 91397 'first byte of BAM on track 18/0
  t = 0
  blocksUsedCounter = 0
  
  For z = 1 To 35
  
     If z < 18 Then
        b = 5
     End If
  
     If z > 17 And z < 25 Then
        b = 3
     End If
    
     If z > 24 And z < 31 Then
        b = 2
     End If
      
     If z > 30 And z < 36 Then
        b = 1
     End If
  
     For r = 1 To 8
       If sBlocks(t).allocated > 0 Then
         trackPart1 = trackPart1 & "0"
       Else
         trackPart1 = trackPart1 & "1"
         blocksFreeCounter = blocksFreeCounter + 1
       End If
       t = t + 1
     Next r
  
     For r = 1 To 8
       If sBlocks(t).allocated > 0 Then
         trackPart2 = trackPart2 & "0"
       Else
         trackPart2 = trackPart2 & "1"
         blocksFreeCounter = blocksFreeCounter + 1
       End If
       t = t + 1
     Next r
     
     For r = 1 To b
       If sBlocks(t).allocated > 0 Then
         trackPart3 = trackPart3 & "0"
       Else
         trackPart3 = trackPart3 & "1"
         blocksFreeCounter = blocksFreeCounter + 1
       End If
       t = t + 1
     Next r
     
      If z < 18 Then
        trackPart3 = trackPart3 & "000"
     End If
  
     If z > 17 And z < 25 Then
        trackPart3 = trackPart3 & "00000"
     End If
    
     If z > 24 And z < 31 Then
        trackPart3 = trackPart3 & "000000"
     End If
      
     If z > 30 And z < 36 Then
        trackPart3 = trackPart3 & "0000000"
     End If
        
     trackPart1 = ReverseString(trackPart1)
     trackPart2 = ReverseString(trackPart2)
     trackPart3 = ReverseString(trackPart3)
     ' dont count directory toward blocks free total
     If z <> 18 Then
       totalBlocksFreeCounter = totalBlocksFreeCounter + blocksFreeCounter
     End If
     blocks2Bite = blocksFreeCounter
     
     '  ltemp is the binary value back to long
   Call convBinToLong(trackPart1)
      tpart1ToBite = ltemp
   Call convBinToLong(trackPart2)
      tpart2ToBite = ltemp
   Call convBinToLong(trackPart3)
      tpart3ToBite = ltemp
      
   Put #1, i, blocks2Bite
      i = i + 1
   Put #1, i, tpart1ToBite
      i = i + 1
   Put #1, i, tpart2ToBite
      i = i + 1
   Put #1, i, tpart3ToBite
      i = i + 1
      
   trackPart1 = ""
   trackPart2 = ""
   trackPart3 = ""
   blocksFreeCounter = 0
  
  Next z
    frmMain.lblBlocksFree = totalBlocksFreeCounter & " BLOCKS FREE."
    
    Close #1
'  --- END BAM SAVE  ----

End Sub

Function traceStream(ByVal track As Byte, ByVal sector As Byte, owner As String, alloc As Integer) As Long
    Dim block As Integer
    Dim prvBlock As Integer
    Dim bCnt As Integer
    
    'clear already viewed flag
    For block = 0 To dimage.sectors - 1
        sBlocks(block).viewed = 0
    Next
    
    If alloc < 0 Then
        prvBlock = -1 'no previous block, no start of file (scratch/wipe)
    Else
        prvBlock = -2 'no prev block but is start of file stream
    End If
    block = convertTrackSectorToBlock(track, sector)
    bCnt = 0 'no blocks yet
    
    While block >= 0 And block < dimage.sectors
                
        If sBlocks(block).viewed > 0 Then 'file loops over itself
            traceStream = Sgn(1 + traceStream) * 2100000000# 'crazy large size
            Exit Function
        End If
        'abort if header,BAM, or 1st Dir sector AND alloc <> 0 (scratch, etc.)
        If alloc <> 0 And track = dimage.sysTrack And sector <= dimage.bamSectors Then
            If bCnt > 0 Then 'this is not the first block of stream
                MsgBox Chr$(34) & chopFilename(owner) & Chr$(34) & " is cross-linked with system block (" & track & "," & sector & ").", vbInformation Or vbOKOnly, "Cross-Link (System)"
            End If
            Exit Function
        End If
        'mark block as viewed to detect loops (also useful for sequence and length)
        bCnt = bCnt + 1
        sBlocks(block).viewed = bCnt
        
        'calc stream size
        If track = 0 Then 'last block
            If sector < 2 Then sector = 2 'invalid byte count, fudge it
            traceStream = Sgn(1 + traceStream) * (Abs(traceStream) + sector - 1)
        Else
            traceStream = Sgn(1 + traceStream) * (Abs(traceStream) + cBlockSize)
        End If
        
        If alloc > 0 Then
            ' check for crosslinked blocks and then set the blockowner
            If sBlocks(block).allocated = 0 Then
                'normal, not already allocated
                sBlocks(block).owner = owner
                sBlocks(block).parent = prvBlock
                sBlocks(block).allocated = 1
                If track = dimage.sysTrack Then 'file on dir track
                    dimage.dirFree = dimage.dirFree - 1 'block not avail for directory
                    If dimage.dirFree < 0 Then
                        MsgBox "Dir blocks free < 0", vbCritical Or vbOKOnly, "Internal Error"
                    End If
                    dimage.maxDirents = dimage.maxDirents - cnDirentsPerSector 'fewer file entries possible
                    If dimage.maxDirents < dimage.dirents Then
                        MsgBox "maxDirents < dirents", vbCritical Or vbOKOnly, "Internal Error"
                    End If
                Else 'file not on dir track
                    dimage.allocated = dimage.allocated + 1 'fewer blocks for files
                    If dimage.allocated > dimage.blocks Then
                        MsgBox "File blocks allocated > num file blocks", vbCritical Or vbOKOnly, "Internal Error"
                    End If
                End If
            Else 'block already allocated, thus cross-linked file
                'this will cause problems if BAM, Dir sector, should be excluded at start of loop
                sBlocks(block).allocated = Abs(sBlocks(block).allocated) + 1 'increase #allocations
                traceStream = -Abs(traceStream) 'make size negative to note cross link
                frmCrossLinks.List1.AddItem Chr$(34) & sBlocks(block).owner & Chr$(34) & " IS CROSSLINKED WITH " & Chr$(34) & owner & Chr$(34) & " AT BLOCK #" & track & ", " & sector
            End If
        ElseIf alloc < 0 Then
            'free block
            If sBlocks(block).allocated = 0 Then
                'block already free
                If alloc < -1 Then
                    'wipe block
                    sBlocks(block).wipe = True
                End If
            Else
                'decrease #allocations
                sBlocks(block).allocated = Sgn(sBlocks(block).allocated) * (Abs(sBlocks(block).allocated) - 1)
                If sBlocks(block).allocated = 0 Then 'now its free
                    If alloc < -1 Then sBlocks(block).wipe = True 'wipe block
                    sBlocks(block).parent = -1
                    sBlocks(block).owner = "** FREE BLOCK **"
                    If track = dimage.sysTrack Then 'file on dir track
                        dimage.dirFree = dimage.dirFree + 1 'block avail for directory
                        If dimage.dirFree + dimage.dirUsed > dimage.dirSectors Then
                            MsgBox "Dir blocks free + dir blocks used > num dir blocks", vbCritical Or vbOKOnly, "Internal Error"
                        End If
                        dimage.maxDirents = dimage.maxDirents + cnDirentsPerSector 'more file entries possible
                        If dimage.maxDirents > dimage.maxDirents2 Then
                            MsgBox "maxDirents > maxDirents2", vbCritical Or vbOKOnly, "Internal Error"
                        End If
                    Else 'file not on dir track
                        dimage.allocated = dimage.allocated - 1 'more blocks for files
                        If dimage.allocated < 0 Then
                            MsgBox "File blocks allocated < 0", vbCritical Or vbOKOnly, "Internal Error"
                        End If
                    End If
                Else 'still not free, cross-limk!
                    traceStream = -Abs(traceStream) 'make size negative to note cross link
                    If sBlocks(block).owner = owner Then
                        'we're marked as the owner, but block still used by somebody else
                        sBlocks(block).owner = "*** UNKNOWN! ***"
                    End If
                End If
            End If
        'Else leave allocation alone
        End If
        
        Get #1, CLng(block) * cSectorSize + 1, track
        Get #1, CLng(block) * cSectorSize + 2, sector
        
        prvBlock = block 'save current block for next loop
        block = convertTrackSectorToBlock(track, sector)
    Wend
End Function

Function traceFile(fnum As Integer, alloc As Integer, stream As Byte, didMsgLoop As Boolean) As Boolean
'returns true if cross-links found
   Dim size As Long
   Dim vlir As Boolean

  If stream = 0 Then
    sDirents(fnum).dataBytes = 0
    sDirents(fnum).vlirBlocks = 0
  ElseIf stream = 1 Then
    sDirents(fnum).indexBytes = 0
  Else
    sDirents(fnum).infoBytes = 0
  End If
      
  If (sDirents(fnum).filetype And 7) = 0 Then Exit Function 'skip scratched / deleted files
    
    vlir = False
    
    If (sDirents(fnum).filetype And 7) < 4 And sDirents(fnum).geoType <> 0 Then
        'GEOS file
        If stream = 2 Then 'info stream
            size = traceStream(sDirents(fnum).info.track, sDirents(fnum).info.sector, sDirents(fnum).name, alloc)
            If size < 0 Then traceFile = True 'note cross-linked
            sDirents(fnum).infoBytes = Abs(size)
            If sDirents(fnum).infoBytes > 2000000000# And didMsgLoop = False Then
                didMsgLoop = vbYes = MsgBox("Corrupt GEOS Info (circular) in file " & _
                    Chr$(34) & chopFilename(sDirents(fnum).name) & Chr$(34) & _
                    "." & vbCrLf & "Suppress further such notices in this disk image?", vbQuestion Or vbYesNo, "File Loop")
            End If
        End If
        If sDirents(fnum).relLength Then
            vlir = True 'GEOS file struture Variable Length Indexed Record
        End If
        If vlir And stream = 0 Then 'get data blocks
            Dim b As Integer
            Dim t As Byte
            Dim s As Byte
            Dim z As Long
            Dim num As Byte
            Dim i As Byte
            Dim circular As Boolean
            b = convertTrackSectorToBlock(sDirents(fnum).start.track, sDirents(fnum).start.sector)
            'check each (valid) index block
            While b >= 0 And b < dimage.sectors
                z = CLng(b) * cSectorSize + 1
                'get #records in this index block
                Get #1, z, t
                Get #1, z + 1, s
                If t = 0 Then
                    b = -1 'no more index blocks
                    n = (CInt(s) - 1) \ 2
                    If n < 1 Then n = 1 'invalid s, fudge it
                Else
                    n = 127 'max #
                    b = convertTrackSectorToBlock(t, s) 'next block
                End If
                'add up the length (and allocate blocks) of records (data blocks)
                For i = 1 To n
                    Get #1, z + i * 2, t
                    Get #1, z + i * 2 + 1, s
                    size = traceStream(t, s, sDirents(fnum).name, alloc)
                    If size < 0 Then traceFile = True 'note cross-linked
                    If Abs(size) > 2000000000# And didMsgLoop = False Then
                        didMsgLoop = vbYes = MsgBox("Corrupt VLIR Record (circular) in file " & _
                            Chr$(34) & chopFilename(sDirents(fnum).name) & Chr$(34) & _
                            "." & vbCrLf & "Suppress further such notices in this disk image?", vbQuestion Or vbYesNo, "File Loop")
                    End If
                    If Abs(size) > 2000000000# Then
                        circular = True
                    Else
                        sDirents(fnum).dataBytes = sDirents(fnum).dataBytes + Abs(size)
                        sDirents(fnum).vlirBlocks = sDirents(fnum).vlirBlocks + (Abs(size) + cSectorSize - 1) \ cSectorSize
                    End If
                Next
            Wend
            If circular Then sDirents(fnum).dataBytes = 2100000000#
        End If 'vlir data stream
    End If 'geos file
   
    If (sDirents(fnum).filetype And 7) = 4 And stream = 1 Then
        'REL file; get index (side sectors) size and allocate blocks
        size = traceStream(sDirents(fnum).info.track, sDirents(fnum).info.sector, sDirents(fnum).name, alloc)
        If size < 0 Then traceFile = True 'note cross-linked
        sDirents(fnum).indexBytes = Abs(size)
        If sDirents(fnum).indexBytes > 2000000000# And didMsgLoop = False Then
            didMsgLoop = vbYes = MsgBox("Corrupt Side-Sectors (circular) in file " & _
                Chr$(34) & chopFilename(sDirents(fnum).name) & Chr$(34) & _
                "." & vbCrLf & "Suppress further such notices in this disk image?", vbQuestion Or vbYesNo, "File Loop")
        End If
    End If
    
    If (sDirents(fnum).filetype And 7) <= 4 And (stream = 0 And vlir = False Or stream = 1 And vlir = True) Then
        'PRG, SEQ, USR, REL, get file data size and allocate blocks
        'actually index size in case of VLIR
        size = traceStream(sDirents(fnum).start.track, sDirents(fnum).start.sector, sDirents(fnum).name, alloc)
        If size < 0 Then traceFile = True 'note cross-linked
        If vlir Then
            sDirents(fnum).indexBytes = Abs(size) 'geos...
            If sDirents(fnum).indexBytes > 2000000000# And didMsgLoop = False Then
                didMsgLoop = vbYes = MsgBox("Corrupt VLIR Index (circular) in file " & _
                    Chr$(34) & chopFilename(sDirents(fnum).name) & Chr$(34) & _
                    "." & vbCrLf & "Suppress further such notices in this disk image?", vbQuestion Or vbYesNo, "File Loop")
            End If
        Else
            sDirents(fnum).dataBytes = Abs(size)
            If sDirents(fnum).dataBytes > 2000000000# And didMsgLoop = False Then
                didMsgLoop = vbYes = MsgBox("Corrupt data (circular) in file " & _
                    Chr$(34) & chopFilename(sDirents(fnum).name) & Chr$(34) & _
                    "." & vbCrLf & "Suppress further such notices in this disk image?", vbQuestion Or vbYesNo, "File Loop")
            End If
        End If
    Else
        'unknown type, do nothing
    End If
End Function

Sub getBlockOwners()
   Dim size As Long
   Dim foundCrosslinks As Boolean
   Dim fnum As Integer
   Dim didMsgLoop As Boolean
   Dim didMsgSize As Long
   Dim tStr As String
   
'   On Error GoTo crashhandler
   
  Load frmCrossLinks
  frmCrossLinks.Top = frmCrossLinksTOP
  frmCrossLinks.Left = frmCrossLinksLEFT
   
  Open frmMain.dialogopen.Filename For Binary As #1

  For fnum = 0 To frmMain.List1.ListCount - 1
          
    'allocate blocks in all streams (if present)
    foundCrosslinks = foundCrosslinks Or traceFile(fnum, 1, 0, didMsgLoop) 'allocate file data
    foundCrosslinks = foundCrosslinks Or traceFile(fnum, 1, 1, didMsgLoop) 'allocate index data
    foundCrosslinks = foundCrosslinks Or traceFile(fnum, 1, 2, didMsgLoop) 'allocate GEOS Info
    
    If (sDirents(fnum).filetype And 7) = 0 Then GoTo fnumCont 'skip scratched / deleted files
          
    If Not (sDirents(fnum).dataBytes > 2000000000# Or sDirents(fnum).indexBytes > 2000000000# Or sDirents(fnum).infoBytes > 2000000000# Or didMsgSize) Then
        'check size matches block count
        If sDirents(fnum).vlirBlocks = 0 Then
            size = (sDirents(fnum).dataBytes + cBlockSize - 1) \ cBlockSize
        Else
            size = sDirents(fnum).vlirBlocks
        End If
        size = size + (sDirents(fnum).indexBytes + cBlockSize - 1) \ cBlockSize
        size = size + (sDirents(fnum).infoBytes + cBlockSize - 1) \ cBlockSize
        If size <> sDirents(fnum).size Then
            Dim ask As Boolean
            ask = False
            If didMsgSize = 0 Then
                ask = True
                didMsgSize = MsgBox("Incorrect block size (" & sDirents(fnum).size & " should be " & size & ")" & vbCrLf & _
                    "for file " & Chr$(34) & chopFilename(sDirents(fnum).name) & Chr$(34) & _
                    "." & vbCrLf & "Correct this file's block size?", vbQuestion Or vbYesNo, "File Size Error")
            End If
            If didMsgSize = vbYes Then 'fix it
                Dim extraspaces As String
                Dim displayfilename As String
                Dim sfiletypedisplay As String
                If sDirents(fnum).filetype Then
                    Call convDecToBin(sDirents(fnum).filetype)
                    Call GETFILETYPE(strBin)
                    sfiletypedisplay = FTYPE & FILEOPEN & FILELOCKED
                Else ' scratched file
                    sfiletypedisplay = "SCR"
                End If
                displayfilename = chopFilename(sDirents(fnum).name)
                extraspaces = ""
                Do While Len(displayfilename) + Len(extraspaces) < 16
                    extraspaces = extraspaces & " "
                Loop
                sDirents(fnum).size = size
                frmMain.List1.RemoveItem fnum
                frmMain.List1.AddItem Chr$(34) & displayfilename & Chr$(34) & extraspaces & vbTab & sDirents(fnum).start.track & vbTab & sDirents(fnum).start.sector & vbTab & sDirents(fnum).size & vbTab & sfiletypedisplay, fnum
                D64Modified = True
            End If
            If ask Then
                If vbNo = MsgBox("Treat all such errors that way?", vbQuestion Or vbYesNo, "File Loop") Then
                    didMsgSize = 0 'clear previous answer -> ask again next time
                End If
            End If
        End If
    End If
    
fnumCont:
  Next fnum
  
  'check for C128 Boot Sector
    Dim test As String
    tStr = "   "
    Get #1, 1, tStr
    If tStr = "CBM" Then 'is boot sector
        '*TODO: trace multi-sector boot*
        If sBlocks(0).allocated = 0 Then
            sBlocks(0).owner = "** C128  BOOT **"
            sBlocks(0).parent = -2 'start of 'boot stream'
            If vbYes = MsgBox("This disk contains a C128 boot sector, but it is not allocated in the BAM." _
                        & vbCrLf & "Fix this error by allocating block (1,0)?", vbExclamation Or vbYesNo, "BAM Error") Then
                D64Modified = True
                sBlocks(0).allocated = 1 'fix by allocating
                dimage.allocated = dimage.allocated + 1
            Else
                sBlocks(0).allocated = -1 'not allocated, but should be
            End If
        Else 'we haven't allocated this yet... cross-link!
            sBlocks(0).allocated = Sgn(sBlocks(0).allocated) * (Abs(sBlocks(0).allocated) + 1) 'increase reference count
            MsgBox "C128 boot block (1,0) is cross-linked with " & Chr(34) & chopFilename(sBlocks(0).owner) & Chr(34) & ".", vbExclamation Or vbOKOnly, "Cross Link Error"
        End If
  End If
  
  'GEOS border
  If dimage.geoBorder.track Then size = traceStream(dimage.geoBorder.track, dimage.geoBorder.sector, "* GEOS  BORDER *", 1) 'allocate stream
  
  Close #1

  If foundCrosslinks = 1 And disableCrosslinkCheck = 0 Then
    frmCrossLinks.Show
  Else
    Unload frmCrossLinks
  End If
  
  
'crashhandler:
'  MsgBox "Directory appears to be corrupted." & vbCrLf & "It is recommended to NOT use this program with this file.", vbInformation, "Corrupted Directory?"
'  frmMain.mnuSaveFile.Enabled = False
'  frmMain.List1.Enabled = False
'  frmMain.txtDiskID.Enabled = False
'  frmMain.txtDiskName.Enabled = False
'  Close #1
'  Exit Sub

End Sub


Sub findFirstBlocktoUse()

    Dim tries As Integer
    Dim giveUp As Integer
    Dim DoNothing As Integer
    'lets start looking at track/sector 17/0
    track = 17
    sector = 0
    distance = 1
    tries = 0
    DoNothing = 0
    block = convertTrackSectorToBlock(track, sector)
    

    If sBlocks(block).allocated > 0 Then 'block is allocated, find another
               
           Do Until sBlocks(block).allocated <= 0
              
                If (track < 18 And track <> 0) And DoNothing = 0 Then
                    If sector < 20 Then
                      sector = sector + 1
                    Else
                      track = 18 + distance
                      sector = 0
                      tries = tries + 1
                      DoNothing = 1
                    End If
                End If
                If (track > 17 And track < 25) And DoNothing = 0 Then
                    If sector < 18 Then
                      sector = sector + 1
                    Else
                      track = 18 - distance
                      sector = 0
                      tries = tries + 1
                      DoNothing = 1
                    End If
                End If
                
                If (track > 24 And track < 31) And DoNothing = 0 Then
                    If sector < 17 Then
                      sector = sector + 1
                    Else
                      track = 18 - distance
                      sector = 0
                      tries = tries + 1
                      DoNothing = 1
                    End If
                End If
                
                If (track > 30 And track < 36) And DoNothing = 0 Then
                    If sector < 16 Then
                      sector = sector + 1
                    Else
                      track = 18 - distance
                      sector = 0
                      tries = tries + 1
                      DoNothing = 1
                    End If
                End If
                
            block = convertTrackSectorToBlock(track, sector)
    
            giveUp = giveUp + 1
            If tries = 2 Then
              distance = distance + 1
              tries = 0
            End If
            
           If giveUp = 1500 Then
             track = 0
             sector = 0
             Exit Do
           End If
           DoNothing = 0
           Loop
End If
End Sub

Sub findNextBlocktoUse()
    Dim previousSector As Integer
    Dim tries As Integer
    
  ' previousSector = sector
    ' step upwards by 10 sector interleave
    sector = sector + 10
previousSector = sector
        If track < 18 And track > 0 Then
            direction = 2
            If sector > 20 Then
              sector = sector - 21
            End If
         End If
         
         If track > 17 And track < 25 Then
            direction = 1
            If sector > 18 Then
              sector = sector - 19
            End If
         End If
         
         If track > 24 And track < 31 Then
            direction = 1
            If sector > 17 Then
              sector = sector - 18
            End If
         End If

         If track > 30 And track < 36 Then
            direction = 1
            If sector > 16 Then
              sector = sector - 17
            End If
         End If

    block = convertTrackSectorToBlock(track, sector)

    Do Until sBlocks(block).allocated <= 0

          If track < 18 And track > 0 Then
            direction = 2
            If sector > 20 Then
              sector = sector - 21
            End If
         End If
         
         If track > 17 And track < 25 Then
            direction = 1
            If sector > 18 Then
              sector = sector - 19
            End If
         End If
         
         If track > 24 And track < 31 Then
            direction = 1
            If sector > 17 Then
              sector = sector - 18
            End If
         End If

         If track > 30 And track < 36 Then
            direction = 1
            If sector > 16 Then
              sector = sector - 17
            End If
         End If
        If tries > 60 Then
          If direction = 1 Then
           track = track + 1
           sector = previousSector
           tries = 0
          End If
          If direction = 2 Then
           track = track - 1
           sector = previousSector
           tries = 0
        End If
          
        End If
          
         If track < 18 And track > 0 Then
            direction = 2
            If sector > 20 Then
              sector = sector - 21
            End If
         End If
         
         If track > 17 And track < 25 Then
            direction = 1
            If sector > 18 Then
              sector = sector - 19
            End If
         End If
         
         If track > 24 And track < 31 Then
            direction = 1
            If sector > 17 Then
              sector = sector - 18
            End If
         End If

         If track > 30 And track < 36 Then
            direction = 1
            If sector > 16 Then
              sector = sector - 17
            End If
         End If
          
        If track < 1 Then
          direction = 1
          track = 19
          sector = 0
        End If
        
        If track > 35 Then
          direction = 2
          track = 17
          sector = 0
        End If
         
 
       block = convertTrackSectorToBlock(track, sector)
 '      MsgBox track & " " & sector & " " & block
     If sBlocks(block).allocated > 0 Then
      sector = sector + 1
     End If
       tries = tries + 1
       
       If tries > 10000 Then
          track = 0
          sector = 0
          Exit Do
       End If
       
    Loop
End Sub

Function convertTrackSectorToBlock(ByVal track As Integer, ByVal sector As Integer) As Integer
    If track < 1 Or track > dimage.tracks Then
        convertTrackSectorToBlock = -1 'bad track
        Exit Function
    End If

    If dimage.imageType = "D81" Then
        If sector >= cnSectorsTrack81 Then
            convertTrackSectorToBlock = -1
        Else
            convertTrackSectorToBlock = CInt(cnSectorsTrack81) * (track - 1) + sector
        End If
        Exit Function
    End If
    
    If dimage.imageType = "D71" And track > cnTracks64 Then
        'side 2, tracks 36 ~ 70
        track = track - 35
        convertTrackSectorToBlock = cnSectors64
    End If
      
    Dim tt As Byte
    
    If track > cTrackZone2 Then tt = cTrackZone2 Else tt = track
    convertTrackSectorToBlock = convertTrackSectorToBlock + CInt(tt - cTrackZone1) * cnSectorsZone1
    If track < cTrackZone2 Then
        If sector >= cnSectorsZone1 Then
            convertTrackSectorToBlock = -1
        Else
            convertTrackSectorToBlock = convertTrackSectorToBlock + sector
        End If
        Exit Function
    End If
    
    If track > cTrackZone3 Then tt = cTrackZone3 Else tt = track
    convertTrackSectorToBlock = convertTrackSectorToBlock + CInt(tt - cTrackZone2) * cnSectorsZone2
    If track < cTrackZone3 Then
        If sector >= cnSectorsZone2 Then
            convertTrackSectorToBlock = -1
        Else
            convertTrackSectorToBlock = convertTrackSectorToBlock + sector
        End If
        Exit Function
    End If
    
    If track > cTrackZone4 Then tt = cTrackZone4 Else tt = track
    convertTrackSectorToBlock = convertTrackSectorToBlock + CInt(tt - cTrackZone3) * cnSectorsZone3
    If track < cTrackZone4 Then
        If sector >= cnSectorsZone3 Then
            convertTrackSectorToBlock = -1
        Else
            convertTrackSectorToBlock = convertTrackSectorToBlock + sector
        End If
        Exit Function
    End If
      
    If sector >= cnSectorsZone4 Then
        convertTrackSectorToBlock = -1
    Else
        convertTrackSectorToBlock = convertTrackSectorToBlock + CInt(track - cTrackZone4) * cnSectorsZone4 + sector
    End If

End Function

Function blockNum2TrackandSector(ByVal blk As Integer) As blockLink
    Dim t As Byte
    Dim skip As Integer
    If blk < 0 Or blk >= dimage.sectors Then 'bad block num
        blockNum2TrackandSector.track = 0 'invalid track
        blockNum2TrackandSector.sector = 1 'invalid sector length (should be 2~255)
        Exit Function
    End If

    If dimage.imageType = "D81" Then
        blockNum2TrackandSector.track = blk \ cnSectorsTrack81 + 1
        blockNum2TrackandSector.sector = blk Mod cnSectorsTrack81
        Exit Function
    End If
    
    If dimage.imageType = "D71" And blk >= 683 Then
        'side 2, tracks 36 ~ 70
        t = 36 'track offset
        blk = blk - 683 'skipped blocks
    Else
        t = 1
    End If
      
    skip = (cTrackZone2 - cTrackZone1) * cnSectorsZone1
    If blk >= skip Then
        t = t + cTrackZone2 - cTrackZone1 'track offset
        blk = blk - skip
    Else
        blockNum2TrackandSector.track = blk \ cnSectorsZone1 + t
        blockNum2TrackandSector.sector = blk Mod cnSectorsZone1
        Exit Function
    End If
      
    skip = (cTrackZone3 - cTrackZone2) * cnSectorsZone2
    If blk >= skip Then
        t = t + cTrackZone3 - cTrackZone2 'track offset
        blk = blk - skip
    Else
        blockNum2TrackandSector.track = blk \ cnSectorsZone2 + t
        blockNum2TrackandSector.sector = blk Mod cnSectorsZone2
        Exit Function
    End If
      
    skip = (cTrackZone4 - cTrackZone3) * cnSectorsZone3
    If blk >= skip Then
        t = t + cTrackZone4 - cTrackZone3 'track offset
        blk = blk - skip
    Else
        blockNum2TrackandSector.track = blk \ cnSectorsZone3 + t
        blockNum2TrackandSector.sector = blk Mod cnSectorsZone3
        Exit Function
    End If
      
    blockNum2TrackandSector.track = blk \ cnSectorsZone4 + t
    blockNum2TrackandSector.sector = blk Mod cnSectorsZone4
End Function


 Sub convDecToBin(ByVal curNumber As Integer)
   Dim j As Long

   strBin = ""
   
   For j = 64 To 0 Step -1
      
     If Int(curNumber / (2 ^ j)) = 1 Then

       strBin = strBin & "1"
       curNumber = curNumber - (2 ^ j)

     Else

         strBin = strBin & "0"

     End If

   Next
   
   strBin = Right(strBin, 8)
   
 End Sub
 
 
 
 Function convBinToLong(strbin2 As String) As Long
   Dim i As Long
   ltemp = 0
   For i = Len(strbin2) To 1 Step -1
     If Mid(strbin2, i, 1) = "1" Then
       ltemp = ltemp + 2 ^ (Len(strbin2) - i)
     End If
   Next i
 End Function

Function ReverseString(sString As String) As String
        Dim sNewString As String
        Dim iCount As Integer
   
        sNewString = ""
        
        For iCount = Len(sString) To 1 Step -1
          sNewString = sNewString & Mid(sString, iCount, 1)
        Next iCount
   
        ReverseString = sNewString
End Function

' Code from VBWORLD.COM to create a temp file
' http://www.vbworld.com/files/tip477.html

Function GetTemporaryFilename(Optional Prefix _
   As String = "") As String

   On Error GoTo TempNameErr

   Dim lngReturnVal As Long

   Dim strTempPath As String * 255
   Dim strTempFilename As String * 255

   lngReturnVal = GetTempPath(254, strTempPath)
   lngReturnVal = GetTempFilename(strTempPath _
   & "\", Prefix, 0, strTempFilename)

   GetTemporaryFilename = strTempFilename

   Exit Function

TempNameErr:

   'Enter any error handling here.
   MsgBox "Cannot retrieve temporary filename - " & _
   Err.Description

   End Function

               
' END CODE FROM VBWORLD.COM
               

' Code to see if a file exists already in the filesystem
' http://216.26.168.92/vbsquare/files/tip360.html

Function FileExists(strPath As String) As Integer
                 Dim lngRetVal As Long
                ' On Error Resume Next
                 lngRetVal = Len(Dir$(strPath))
                 If Err Or lngRetVal = 0 Then
                 FileExists = False
                 Else
                 FileExists = True
                 End If
End Function


' End code from VBSQUARE
